/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.events;

import com.xiaoyue.tinkers_ingenuity.content.library.context.ArrowImpactContext;
import com.xiaoyue.tinkers_ingenuity.content.library.events.ItemStackDamageEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.events.LivingCalculateAbsEvent;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.IngenuityHooks;
import com.xiaoyue.tinkers_ingenuity.content.library.tools.TIToolStats;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.CurioAddonHook;
import com.xiaoyue.tinkers_ingenuity.generic.Interface.curio.CurioAttackHook;
import com.xiaoyue.tinkers_ingenuity.utils.ToolUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;

@Mod.EventBusSubscriber(modid="tinkers_ingenuity", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CurioHookHandler {
    private static CurioAttackHook attack(ModifierEntry entry) {
        return (CurioAttackHook)entry.getHook(IngenuityHooks.CURIO_ATTACK_HOOK);
    }

    private static CurioAddonHook addon(ModifierEntry entry) {
        return (CurioAddonHook)entry.getHook(IngenuityHooks.CURIO_ADDON_HOOK);
    }

    @SubscribeEvent
    public static void onDamageStack(ItemStackDamageEvent event) {
        LivingEntity entity = event.getEntity();
        ToolUtils.Curios.getStacks(entity).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.addon(e).onCurioGetToolDamage((IToolStackView)curio, entity, event, e.getLevel()));
        });
    }

    private static void onHurtEntity(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ToolUtils.Curios.getStacks(attacker).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioToHurt((IToolStackView)curio, event, attacker, event.getEntity(), e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        LivingEntity entity = event.getEntity();
        ToolUtils.Curios.getStacks(entity).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioTakeHurt((IToolStackView)curio, event, entity, event.getSource(), e.getLevel()));
        });
        CurioHookHandler.onHurtEntity(event);
    }

    private static void onDamageEntity(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ToolUtils.Curios.getStacks(attacker).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioToDamage((IToolStackView)curio, event, attacker, event.getEntity(), e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        ToolUtils.Curios.getStacks(entity).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioTakeDamage((IToolStackView)curio, event, entity, event.getSource(), e.getLevel()));
        });
        CurioHookHandler.onDamageEntity(event);
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        ToolUtils.Curios.getStacks(attacker).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioToKill((IToolStackView)curio, event, attacker, event.getEntity(), e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onLivingCalculate(LivingCalculateAbsEvent event) {
        LivingEntity attacker = event.getLivingAttacker();
        if (attacker == null) {
            return;
        }
        ToolUtils.Curios.getStacks(attacker).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.attack(e).onCurioToDamageAbs((IToolStackView)curio, event, attacker, event.getEntity(), e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        LivingEntity entity = event.getEntity();
        ToolUtils.Curios.getStacks(entity).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.addon(e).onCurioTakeHeal((IToolStackView)curio, event, entity, e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onShootArrow(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)entity;
        Entity entity2 = arrow.m_37282_();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity3 = (LivingEntity)entity2;
        ToolUtils.Curios.getStacks(entity3).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> {
                float arrow_damage = ConditionalStatModifierHook.getModifiedStat((IToolStackView)curio, (LivingEntity)entity3, (FloatToolStat)TIToolStats.ARROW_DAMAGE);
                arrow.m_36781_(arrow.m_36789_() * (double)(1.0f + arrow_damage));
                CurioHookHandler.addon(e).onCurioShootArrow((IToolStackView)curio, entity3, arrow, e.getLevel());
            });
        });
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof AbstractArrow)) {
            return;
        }
        AbstractArrow arrow = (AbstractArrow)projectile;
        Entity entity = arrow.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity shooter = (LivingEntity)entity;
        ToolUtils.Curios.getStacks(shooter).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.addon(e).onCurioArrowHit((IToolStackView)curio, shooter, new ArrowImpactContext(event, arrow), e.getLevel()));
        });
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ToolUtils.Curios.getStacks((LivingEntity)event.getEntity()).forEach(stack -> {
            ToolStack curio = ToolStack.from((ItemStack)stack);
            curio.getModifierList().forEach(e -> CurioHookHandler.addon(e).onCurioBreakSpeed((IToolStackView)curio, event, event.getEntity(), e.getLevel()));
        });
    }
}

